*Generate .ado file for publicaiton

/*
INSTRUCTIONS:
*This program generates EQ-5D-5L utilities using the UK value set and the cross-
walk to the EQ-5D-3L value set (van Hout et al, Interim scoring for the 
EQ-5D-5L: mapping the EQ-5D-5L to EQ-5D-3L value sets. Value Health 2012)

Note: this program opens new dataset and will close those currently open. Please
 ensure that all data are saved before this program is run.

information required:
 qolad: this needs to include all 13 QoL-AD items. If item 7 is not available
	the dataset, this variable needs to be created as a constant.
	The items need to be listed in the correct order (i.e. starting with item 1, 
	and proceding in increasing order to item 13.
	the QoL-AD data need to be coded as follows: 
	1=Poor, 2=Fair, 3=Good, 4=Excellent"
 sex: needs to be coded 1 for male, 0 for female
 age: the age of the participant (at each observation, if longitudinal data are
	used)
 coeff: specify the location at which the datasets containing the model 
	coefficients are saved
*/
 
 
cap program drop mapQoladToEq5d
program mapQoladToEq5d 
 syntax , qolad(string) sex(string) age(string) ///
 scenario(string) item7(string) model(string) ///
 coeffs(string) 
 
local error = 0
local num: word count $"`qolad'"
if `"`num'"' != "13" {
 di as error "Please ensure that all 13 QoL-AD variable have been entered"
 local error = `error' + 1
}

local num: word count $"`sex'"
if `"`num'"' != "1" {
 di as error "Please ensure that only one variable indicating sex is entered"
 local error = `error' + 1
}

local num: word count $"`age'"
if `"`num'"' != "1" {
 di as error "Please ensure that only one variable indicating age is entered"
 local error = `error' + 1
}

if  !inlist(`"`scenario'"',"SelfEQ_SelfQOL","ProxyEQ_SelfQOL","SelfEQ_ProxyQOL","ProxyEQ_ProxyQOL") {
 di as error "Please ensure a correct option for 'scenario' is entered"
 local error = `error' + 1
}

if  !inlist(`"`item7'"',"ExcludingItem7","IncludingItem7") {
 di as error "Please ensure a correct option for 'item7' is entered"
 local error = `error' + 1
}

if  !inlist(`"`model'"',"mlogit","tobit") {
 di as error "Please ensure a correct option for 'model' is entered"
 local error = `error' + 1
}

*ensure that all variables listed in the program syntax are available in the 
* dataset specified - remove so that new data are added to current dataset
foreach i in `qolad' `sex' `age' {
 quietly capture: su `i'
 if _rc != 0 {
 di as error "The variable `i' does not exist in the specified dataset. Please check the input"
 local error = `error' + 1
 }
 }
 
 *catpure that coding is correct:
foreach i in `qolad' ` {
 quietly capture: su `i'
 if r(min) <1 | r(max) > 4 {
 di as error "The variable `i' is not coded correctly. Please ensure that values range from 1 to 4 only"
 local error = `error' + 1
 }
 }

foreach i in `sex' ` {
 quietly capture: su `i'
 if r(min) <0 | r(max) > 1 {
 di as error "The variable `i' is not coded correctly. Please ensure that values are coded 0 (female) and 1 (male) only"
 local error = `error' + 1
 }
 }
 

 
if `"`error'"' != "0" {
 di as error "Please correct all errors to enable the program to run"
}

if `"`error'"' == "0" {
quietly {


* 1. step - obtain results from tobit:
if `"`model'"' == "tobit" {
estimates use "`coeffs'/`model'_`scenario'_`item7'"
predict eq5d5l_t, ystar(-.594,1)
label var eq5d5l_t ///
 "EQ-5D-5D utility - UK value set (crosswalk to 3L value set, van Hout, 2012) - mapped from QoL-AD using Tobit model"

}



*2. step: Get predictions from mlogit
if `"`model'"' == "mlogit" {

*a - get predictions
estimates use "`coeffs'/`model'_EQ1_`scenario'_`item7'"
predict mob_p1 mob_p2 mob_p3 mob_p4 mob_p5, pr

estimates use "`coeffs'/`model'_EQ2_`scenario'_`item7'"
predict sc_p1 sc_p2 sc_p3 sc_p4 sc_p5, pr

estimates use "`coeffs'/`model'_EQ3_`scenario'_`item7'"
predict ac_p1 ac_p2 ac_p3 ac_p4 ac_p5, pr

estimates use "`coeffs'/`model'_EQ4_`scenario'_`item7'"
predict pa_p1 pa_p2 pa_p3 pa_p4 pa_p5, pr

estimates use "`coeffs'/`model'_EQ5_`scenario'_`item7'"
predict ad_p1 ad_p2 ad_p3 ad_p4 ad_p5, pr

*b - apply sransition matrices
gen pr3l_mob1_mlogit = mob_p1 + 0.18*mob_p2
gen pr3l_mob2_mlogit = 0.82*mob_p2 + mob_p3 + 0.93*mob_p4
gen pr3l_mob3_mlogit = 0.07*mob_p4 + mob_p5

gen pr3l_sc1_mlogit = sc_p1 + 0.17*sc_p2
gen pr3l_sc2_mlogit = 0.83*sc_p2 + sc_p3 + 0.76*sc_p4
gen pr3l_sc3_mlogit = 0.24*sc_p4 + sc_p5

gen pr3l_act1_mlogit = ac_p1 + 0.2*ac_p2
gen pr3l_act2_mlogit = 0.8*ac_p2 + ac_p3 + 0.67*ac_p4
gen pr3l_act3_mlogit = 0.33*ac_p4 + ac_p5

gen pr3l_pain1_mlogit = pa_p1 + 0.2*pa_p2
gen pr3l_pain2_mlogit = 0.8*pa_p2 + pa_p3 + 0.60*pa_p4
gen pr3l_pain3_mlogit = 0.40*pa_p4 + pa_p5

gen pr3l_ad1_mlogit = ad_p1 + 0.21*ad_p2
gen pr3l_ad2_mlogit = 0.79*ad_p2 + ad_p3 + 0.51*ad_p4
gen pr3l_ad3_mlogit = 0.49*ad_p4+ ad_p5

*c - generate EQ5D3L using cross-walk
generate prPerfect_mlogit= (1-pr3l_mob3_mlogit-pr3l_mob2_mlogit)*(1-pr3l_sc3_mlogit-pr3l_sc2_mlogit)* ///
 (1-pr3l_act3_mlogit-pr3l_act2_mlogit)*(1-pr3l_pain3_mlogit-pr3l_pain2_mlogit)*(1-pr3l_ad3_mlogit-pr3l_ad2_mlogit)
generate prN3_mlogit = 1- (1-pr3l_mob3_mlogit)*(1-pr3l_sc3_mlogit)*(1-pr3l_act3_mlogit)*(1-pr3l_pain3_mlogit)*(1-pr3l_ad3_mlogit)
generate eq5d5l_m = 1 - pr3l_mob2_mlogit*.069 - pr3l_mob3_mlogit*.314 - pr3l_sc2_mlogit*.104 ///
 - pr3l_sc3_mlogit*.214 - pr3l_act2_mlogit*.036 - pr3l_act3_mlogit*.094 - pr3l_pain2_mlogit*.123 - pr3l_pain3_mlogit*.386 ///
 - pr3l_ad2_mlogit*.071 - pr3l_ad3_mlogit*.236 - (1-prPerfect_mlogit)* .081 - prN3*.269

*drop variables no longer needed
drop pr3l_mob1_mlogit pr3l_mob2_mlogit pr3l_mob3_mlogit ///
 pr3l_sc1_mlogit pr3l_sc3_mlogit pr3l_sc3_mlogit ///
 pr3l_act1_mlogit pr3l_act2_mlogit pr3l_act3_mlogit  ///
 pr3l_pain1_mlogit pr3l_pain2_mlogit pr3l_pain3_mlogit ///
 pr3l_ad1_mlogit pr3l_ad2_mlogit pr3l_ad3_mlogit ///
 prPerfect_mlogit prN3_mlogit


*label newly created variables
label var mob_p1 "Probability of falling into level 1 of the mobility domain"
label var mob_p2 "Probability of falling into level 2 of the mobility domain"
label var mob_p3 "Probability of falling into level 3 of the mobility domain"
label var mob_p4 "Probability of falling into level 4 of the mobility domain"
label var mob_p5 "Probability of falling into level 5 of the mobility domain"
label var sc_p1 "Probability of falling into level 1 of the self-care domain"
label var sc_p2 "Probability of falling into level 2 of the self-care domain"
label var sc_p3 "Probability of falling into level 3 of the self-care domain"
label var sc_p4 "Probability of falling into level 4 of the self-care domain"
label var sc_p5 "Probability of falling into level 5 of the self-care domain"
label var ac_p1 "Probability of falling into level 1 of the usual activities domain"
label var ac_p2 "Probability of falling into level 2 of the usual activities domain"
label var ac_p3 "Probability of falling into level 3 of the usual activities domain"
label var ac_p4 "Probability of falling into level 4 of the usual activities domain"
label var ac_p5 "Probability of falling into level 5 of the usual activities domain"
label var pa_p1 "Probability of falling into level 1 of the pain domain"
label var pa_p2 "Probability of falling into level 2 of the pain domain"
label var pa_p3 "Probability of falling into level 3 of the pain domain"
label var pa_p4 "Probability of falling into level 4 of the pain domain"
label var pa_p5 "Probability of falling into level 5 of the pain domain"
label var ad_p1 "Probability of falling into level 1 of the anxiety and depression domain"
label var ad_p2 "Probability of falling into level 2 of the anxiety and depression domain"
label var ad_p3 "Probability of falling into level 3 of the anxiety and depression domain"
label var ad_p4 "Probability of falling into level 4 of the anxiety and depression domain"
label var ad_p5 "Probability of falling into level 5 of the anxiety and depression domain"
label var eq5d5l_m "EQ-5D-5D utility - UK value set (crosswalk to 3L value set, van Hout, 2012) - mapped from QoL-AD using mLogit model"
}
}
}

end
